
$(function () {
	$.validator.setDefaults({
		submitHandler: function (form) {
			form.submit();
		}
	});

	$('#js-product-form').validate({
		rules: {
			name: {
				required: true
			},
			code: {
				required: true
			},
			price: {
				required: true,
				number: true,
			},
			product_image: {
				required: false,
				accept: 'image/jpeg, image/png, image/gif',
			}
		},
		messages: {
			name: "Please enter name",
			code: "Please enter code",
			price: {
				required: "Please enter price",
				number: "Please enter a valid price"
			},
			product_image: {
				accept: 'Please select a valid image file (JPEG, PNG, GIF)',
			}
		},
		errorElement: 'span',
		errorPlacement: function (error, element) {
			error.addClass('invalid-feedback');
			element.closest('.form-group').append(error);
		},
		highlight: function (element, errorClass, validClass) {
			$(element).addClass('is-invalid');
		},
		unhighlight: function (element, errorClass, validClass) {
			$(element).removeClass('is-invalid');
		}
	});
});
